# ICONS Colour Utilities

This folder bundles a set of helpers for turning colour measurements into the
new `ColorStimulus` model and deriving human-friendly colour names. The key
artifacts you just added are:

- `colorstimuli.py`: conversion functions (`xyz_to_colorstimulus`,
  `xyz2colorname`, etc.)
- `display.py`: minimal sRGB ⇄ XYZ helper used by the conversions
- `xyz_colorname_ui.py`: Tkinter UI for quick lookups

Below is a cheat sheet so teammates can either run the UI or work from the
command line.

## 1. Prerequisites

1. Install Python 3.13 (or follow your local project standard).
2. Make sure the `colour-science` package is available:
   ```bash
   python -m pip install colour-science
   ```
3. From a shell or PowerShell session, change into this directory:
   ```bash
   cd "D:\Development File\ICONS"
   ```

## 2. Running the GUI

1. Start the UI with:
   ```bash
   python xyz_colorname_ui.py
   ```
2. Populate the three XYZ fields (values are on the 0–100 scale).
3. Optional: override the reference white (`Xw`, `Yw`, `Zw`). Click “Use Default
   Whitepoint” to reset to the built-in D65 values or to whatever your
   `global_config` exposes.
4. Click **Compute Color Name**. The colour swatch updates, and you’ll see:
   - Classification (e.g., “Green”)
   - NCS hue notation
   - Depth description
   - Generated `u_name`
   - Corresponding Lab* and JCh triplets

The window stays responsive until you close it; running the command inside the
CLI may appear to “hang” because the process is waiting for the GUI to exit.

## 3. Command-Line Usage

You can call the helpers directly from Python without the UI. Examples below
assume you are still in the project directory.

### 3.1 Quick colour name lookup

```bash
python -c "from colorstimuli import xyz2colorname; \
print(xyz2colorname([41.24, 21.26, 1.93]))"
```

This prints the basic classification (e.g., `Red`). Supply `include_details=True`
to retrieve the full metadata bundle:

```bash
python -c "from pprint import pprint; \
from colorstimuli import xyz2colorname; \
pprint(xyz2colorname([41.24, 21.26, 1.93], include_details=True))"
```

### 3.2 Custom whitepoint / viewing conditions

If you need to override the default D65 whitepoint or other settings, pass them
explicitly:

```python
from colorstimuli import xyz2colorname

xyz = [20.0, 18.0, 55.0]
custom_xyzw = [96.42, 100.0, 82.49]  # D50

info = xyz2colorname(xyz, xyzw=custom_xyzw, include_details=True)
print(info["color_name"], info["ncs_name"])
```

You can run the snippet above in a REPL or place it in a script.

## 4. Notes

- `xyz2colorname` and `xyz_to_colorstimulus` will fall back to a built-in
  configuration (D65, La = 64, Yb = 20, surround = “avg”) if the wider package
  modules (`config`, `display`) are absent.
- The new `DisplayModel` supports only sRGB. Extend `display.py` if you need
  additional colour spaces.
- The UI and CLI both expect XYZ values scaled to a Y=100 reference white; adjust
  your measurements accordingly before calling the functions.

## 5. Automated Tests

Regression checks live under `tests/`. They verify the core conversion pipeline
and naming logic for representative colours (sRGB primaries and basic error
handling). Run them whenever you change the maths or classification rules:

```bash
python -m unittest discover -s tests -p "test_*.py"
```

Feel free to copy/paste these examples into your own documentation or onboarding
materials.
